package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{ResourceName, Id}
import scala.jdk.CollectionConverters._
final case class BatchDeleteDevicePositionHistoryRequest(
    deviceIds: Iterable[Id],
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest = {
    import BatchDeleteDevicePositionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
      .builder()
      .deviceIds(deviceIds.map { item =>
        Id.unwrap(item): java.lang.String
      }.asJavaCollection)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest.ReadOnly =
    zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest
      .wrap(buildAwsValue())
}
object BatchDeleteDevicePositionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest =
      zio.aws.location.model
        .BatchDeleteDevicePositionHistoryRequest(deviceIds, trackerName)
    def deviceIds: List[Id]
    def trackerName: ResourceName
    def getDeviceIds: ZIO[Any, Nothing, List[Id]] = ZIO.succeed(deviceIds)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
  ) extends zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest.ReadOnly {
    override val deviceIds: List[Id] = impl
      .deviceIds()
      .asScala
      .map { item =>
        zio.aws.location.model.primitives.Id(item)
      }
      .toList
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
  ): zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
