package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{Id, ResourceName}
import scala.jdk.CollectionConverters._
final case class BatchDeleteGeofenceRequest(
    collectionName: ResourceName,
    geofenceIds: Iterable[Id]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest = {
    import BatchDeleteGeofenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .geofenceIds(geofenceIds.map { item =>
        Id.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchDeleteGeofenceRequest.ReadOnly =
    zio.aws.location.model.BatchDeleteGeofenceRequest.wrap(buildAwsValue())
}
object BatchDeleteGeofenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchDeleteGeofenceRequest =
      zio.aws.location.model
        .BatchDeleteGeofenceRequest(collectionName, geofenceIds)
    def collectionName: ResourceName
    def geofenceIds: List[Id]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getGeofenceIds: ZIO[Any, Nothing, List[Id]] = ZIO.succeed(geofenceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest
  ) extends zio.aws.location.model.BatchDeleteGeofenceRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val geofenceIds: List[Id] = impl
      .geofenceIds()
      .asScala
      .map { item =>
        zio.aws.location.model.primitives.Id(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteGeofenceRequest
  ): zio.aws.location.model.BatchDeleteGeofenceRequest.ReadOnly = new Wrapper(
    impl
  )
}
