package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchEvaluateGeofencesResponse(
    errors: Iterable[zio.aws.location.model.BatchEvaluateGeofencesError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse = {
    import BatchEvaluateGeofencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly =
    zio.aws.location.model.BatchEvaluateGeofencesResponse.wrap(buildAwsValue())
}
object BatchEvaluateGeofencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchEvaluateGeofencesResponse =
      zio.aws.location.model.BatchEvaluateGeofencesResponse(errors.map { item =>
        item.asEditable
      })
    def errors
        : List[zio.aws.location.model.BatchEvaluateGeofencesError.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchEvaluateGeofencesError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse
  ) extends zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly {
    override val errors
        : List[zio.aws.location.model.BatchEvaluateGeofencesError.ReadOnly] =
      impl
        .errors()
        .asScala
        .map { item =>
          zio.aws.location.model.BatchEvaluateGeofencesError.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesResponse
  ): zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly =
    new Wrapper(impl)
}
