package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class BatchPutGeofenceError(
    error: zio.aws.location.model.BatchItemError,
    geofenceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchPutGeofenceError = {
    import BatchPutGeofenceError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchPutGeofenceError
      .builder()
      .error(error.buildAwsValue())
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchPutGeofenceError.ReadOnly =
    zio.aws.location.model.BatchPutGeofenceError.wrap(buildAwsValue())
}
object BatchPutGeofenceError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchPutGeofenceError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchPutGeofenceError =
      zio.aws.location.model.BatchPutGeofenceError(error.asEditable, geofenceId)
    def error: zio.aws.location.model.BatchItemError.ReadOnly
    def geofenceId: Id
    def getError
        : ZIO[Any, Nothing, zio.aws.location.model.BatchItemError.ReadOnly] =
      ZIO.succeed(error)
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceError
  ) extends zio.aws.location.model.BatchPutGeofenceError.ReadOnly {
    override val error: zio.aws.location.model.BatchItemError.ReadOnly =
      zio.aws.location.model.BatchItemError.wrap(impl.error())
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceError
  ): zio.aws.location.model.BatchPutGeofenceError.ReadOnly = new Wrapper(impl)
}
