package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PropertyMapValueString,
  PropertyMapKeyString,
  Id
}
import scala.jdk.CollectionConverters._
final case class BatchPutGeofenceRequestEntry(
    geofenceId: Id,
    geofenceProperties: Optional[
      Map[PropertyMapKeyString, PropertyMapValueString]
    ] = Optional.Absent,
    geometry: zio.aws.location.model.GeofenceGeometry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry = {
    import BatchPutGeofenceRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
      .builder()
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .optionallyWith(
        geofenceProperties.map(value =>
          value
            .map({ case (key, value) =>
              (PropertyMapKeyString
                .unwrap(key): java.lang.String) -> (PropertyMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.geofenceProperties)
      .geometry(geometry.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly =
    zio.aws.location.model.BatchPutGeofenceRequestEntry.wrap(buildAwsValue())
}
object BatchPutGeofenceRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchPutGeofenceRequestEntry =
      zio.aws.location.model.BatchPutGeofenceRequestEntry(
        geofenceId,
        geofenceProperties.map(value => value),
        geometry.asEditable
      )
    def geofenceId: Id
    def geofenceProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]]
    def geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
    def getGeofenceProperties: ZIO[Any, AwsError, Map[
      PropertyMapKeyString,
      PropertyMapValueString
    ]] = AwsError.unwrapOptionField("geofenceProperties", geofenceProperties)
    def getGeometry
        : ZIO[Any, Nothing, zio.aws.location.model.GeofenceGeometry.ReadOnly] =
      ZIO.succeed(geometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
  ) extends zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly {
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
    override val geofenceProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geofenceProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.location.model.primitives
                .PropertyMapKeyString(key) -> zio.aws.location.model.primitives
                .PropertyMapValueString(value)
            })
            .toMap
        )
    override val geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly =
      zio.aws.location.model.GeofenceGeometry.wrap(impl.geometry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceRequestEntry
  ): zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly = new Wrapper(
    impl
  )
}
