package zio.aws.location.model
import zio.aws.location.model.primitives.{Timestamp, ResourceName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CalculateRouteRequest(
    calculatorName: ResourceName,
    carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions
    ] = Optional.Absent,
    departNow: Optional[Boolean] = Optional.Absent,
    departurePosition: Iterable[Double],
    departureTime: Optional[Timestamp] = Optional.Absent,
    destinationPosition: Iterable[Double],
    distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      Optional.Absent,
    includeLegGeometry: Optional[Boolean] = Optional.Absent,
    travelMode: Optional[zio.aws.location.model.TravelMode] = Optional.Absent,
    truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions
    ] = Optional.Absent,
    waypointPositions: Optional[Iterable[Iterable[Double]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteRequest = {
    import CalculateRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .optionallyWith(carModeOptions.map(value => value.buildAwsValue()))(
        _.carModeOptions
      )
      .optionallyWith(departNow.map(value => value: java.lang.Boolean))(
        _.departNow
      )
      .departurePosition(departurePosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        departureTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.departureTime)
      .destinationPosition(destinationPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .optionallyWith(
        includeLegGeometry.map(value => value: java.lang.Boolean)
      )(_.includeLegGeometry)
      .optionallyWith(travelMode.map(value => value.unwrap))(_.travelMode)
      .optionallyWith(truckModeOptions.map(value => value.buildAwsValue()))(
        _.truckModeOptions
      )
      .optionallyWith(
        waypointPositions.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.Double
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.waypointPositions)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteRequest.ReadOnly =
    zio.aws.location.model.CalculateRouteRequest.wrap(buildAwsValue())
}
object CalculateRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteRequest =
      zio.aws.location.model.CalculateRouteRequest(
        calculatorName,
        carModeOptions.map(value => value.asEditable),
        departNow.map(value => value),
        departurePosition,
        departureTime.map(value => value),
        destinationPosition,
        distanceUnit.map(value => value),
        includeLegGeometry.map(value => value),
        travelMode.map(value => value),
        truckModeOptions.map(value => value.asEditable),
        waypointPositions.map(value => value)
      )
    def calculatorName: ResourceName
    def carModeOptions
        : Optional[zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly]
    def departNow: Optional[Boolean]
    def departurePosition: List[Double]
    def departureTime: Optional[Timestamp]
    def destinationPosition: List[Double]
    def distanceUnit: Optional[zio.aws.location.model.DistanceUnit]
    def includeLegGeometry: Optional[Boolean]
    def travelMode: Optional[zio.aws.location.model.TravelMode]
    def truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ]
    def waypointPositions: Optional[List[List[Double]]]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getCarModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("carModeOptions", carModeOptions)
    def getDepartNow: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("departNow", departNow)
    def getDeparturePosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(departurePosition)
    def getDepartureTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("departureTime", departureTime)
    def getDestinationPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(destinationPosition)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.location.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
    def getIncludeLegGeometry: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeLegGeometry", includeLegGeometry)
    def getTravelMode: ZIO[Any, AwsError, zio.aws.location.model.TravelMode] =
      AwsError.unwrapOptionField("travelMode", travelMode)
    def getTruckModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("truckModeOptions", truckModeOptions)
    def getWaypointPositions: ZIO[Any, AwsError, List[List[Double]]] =
      AwsError.unwrapOptionField("waypointPositions", waypointPositions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteRequest
  ) extends zio.aws.location.model.CalculateRouteRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.carModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteCarModeOptions.wrap(value)
      )
    override val departNow: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.departNow())
      .map(value => value: Boolean)
    override val departurePosition: List[Double] = impl
      .departurePosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val departureTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.departureTime())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val destinationPosition: List[Double] = impl
      .destinationPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distanceUnit())
        .map(value => zio.aws.location.model.DistanceUnit.wrap(value))
    override val includeLegGeometry: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeLegGeometry())
      .map(value => value: Boolean)
    override val travelMode: Optional[zio.aws.location.model.TravelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.travelMode())
        .map(value => zio.aws.location.model.TravelMode.wrap(value))
    override val truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.truckModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteTruckModeOptions.wrap(value)
      )
    override val waypointPositions: Optional[List[List[Double]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.waypointPositions())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item: Double
            }.toList
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteRequest
  ): zio.aws.location.model.CalculateRouteRequest.ReadOnly = new Wrapper(impl)
}
