package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{ResourceName, GeoArn, Timestamp}
import scala.jdk.CollectionConverters._
final case class CreateMapResponse(
    createTime: Timestamp,
    mapArn: GeoArn,
    mapName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateMapResponse = {
    import CreateMapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateMapResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .mapArn(GeoArn.unwrap(mapArn): java.lang.String)
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateMapResponse.ReadOnly =
    zio.aws.location.model.CreateMapResponse.wrap(buildAwsValue())
}
object CreateMapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateMapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateMapResponse =
      zio.aws.location.model.CreateMapResponse(createTime, mapArn, mapName)
    def createTime: Timestamp
    def mapArn: GeoArn
    def mapName: ResourceName
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getMapArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(mapArn)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateMapResponse
  ) extends zio.aws.location.model.CreateMapResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val mapArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.mapArn())
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateMapResponse
  ): zio.aws.location.model.CreateMapResponse.ReadOnly = new Wrapper(impl)
}
