package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{ResourceName, GeoArn, Timestamp}
import scala.jdk.CollectionConverters._
final case class CreatePlaceIndexResponse(
    createTime: Timestamp,
    indexArn: GeoArn,
    indexName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse = {
    import CreatePlaceIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .indexArn(GeoArn.unwrap(indexArn): java.lang.String)
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly =
    zio.aws.location.model.CreatePlaceIndexResponse.wrap(buildAwsValue())
}
object CreatePlaceIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreatePlaceIndexResponse =
      zio.aws.location.model
        .CreatePlaceIndexResponse(createTime, indexArn, indexName)
    def createTime: Timestamp
    def indexArn: GeoArn
    def indexName: ResourceName
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getIndexArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(indexArn)
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse
  ) extends zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val indexArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.indexArn())
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreatePlaceIndexResponse
  ): zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
