package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, GeoArn}
import scala.jdk.CollectionConverters._
final case class CreateRouteCalculatorResponse(
    calculatorArn: GeoArn,
    calculatorName: ResourceName,
    createTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse = {
    import CreateRouteCalculatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse
      .builder()
      .calculatorArn(GeoArn.unwrap(calculatorArn): java.lang.String)
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly =
    zio.aws.location.model.CreateRouteCalculatorResponse.wrap(buildAwsValue())
}
object CreateRouteCalculatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateRouteCalculatorResponse =
      zio.aws.location.model.CreateRouteCalculatorResponse(
        calculatorArn,
        calculatorName,
        createTime
      )
    def calculatorArn: GeoArn
    def calculatorName: ResourceName
    def createTime: Timestamp
    def getCalculatorArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(calculatorArn)
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse
  ) extends zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly {
    override val calculatorArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.calculatorArn())
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateRouteCalculatorResponse
  ): zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly =
    new Wrapper(impl)
}
