package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeleteKeyRequest(keyName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeleteKeyRequest = {
    import DeleteKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeleteKeyRequest
      .builder()
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DeleteKeyRequest.ReadOnly =
    zio.aws.location.model.DeleteKeyRequest.wrap(buildAwsValue())
}
object DeleteKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeleteKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeleteKeyRequest =
      zio.aws.location.model.DeleteKeyRequest(keyName)
    def keyName: ResourceName
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeleteKeyRequest
  ) extends zio.aws.location.model.DeleteKeyRequest.ReadOnly {
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeleteKeyRequest
  ): zio.aws.location.model.DeleteKeyRequest.ReadOnly = new Wrapper(impl)
}
