package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeleteMapRequest(mapName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeleteMapRequest = {
    import DeleteMapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeleteMapRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DeleteMapRequest.ReadOnly =
    zio.aws.location.model.DeleteMapRequest.wrap(buildAwsValue())
}
object DeleteMapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeleteMapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeleteMapRequest =
      zio.aws.location.model.DeleteMapRequest(mapName)
    def mapName: ResourceName
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeleteMapRequest
  ) extends zio.aws.location.model.DeleteMapRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeleteMapRequest
  ): zio.aws.location.model.DeleteMapRequest.ReadOnly = new Wrapper(impl)
}
