package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ApiKey,
  ResourceDescription,
  Timestamp,
  TagValue,
  Arn,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeKeyResponse(
    createTime: Timestamp,
    description: Optional[ResourceDescription] = Optional.Absent,
    expireTime: Timestamp,
    key: ApiKey,
    keyArn: Arn,
    keyName: ResourceName,
    restrictions: zio.aws.location.model.ApiKeyRestrictions,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeKeyResponse = {
    import DescribeKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeKeyResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .expireTime(Timestamp.unwrap(expireTime): Instant)
      .key(ApiKey.unwrap(key): java.lang.String)
      .keyArn(Arn.unwrap(keyArn): java.lang.String)
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .restrictions(restrictions.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeKeyResponse.ReadOnly =
    zio.aws.location.model.DescribeKeyResponse.wrap(buildAwsValue())
}
object DescribeKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeKeyResponse =
      zio.aws.location.model.DescribeKeyResponse(
        createTime,
        description.map(value => value),
        expireTime,
        key,
        keyArn,
        keyName,
        restrictions.asEditable,
        tags.map(value => value),
        updateTime
      )
    def createTime: Timestamp
    def description: Optional[ResourceDescription]
    def expireTime: Timestamp
    def key: ApiKey
    def keyArn: Arn
    def keyName: ResourceName
    def restrictions: zio.aws.location.model.ApiKeyRestrictions.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def updateTime: Timestamp
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getExpireTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(expireTime)
    def getKey: ZIO[Any, Nothing, ApiKey] = ZIO.succeed(key)
    def getKeyArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(keyArn)
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
    def getRestrictions: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.ApiKeyRestrictions.ReadOnly
    ] = ZIO.succeed(restrictions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeKeyResponse
  ) extends zio.aws.location.model.DescribeKeyResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val expireTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.expireTime())
    override val key: ApiKey =
      zio.aws.location.model.primitives.ApiKey(impl.key())
    override val keyArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.keyArn())
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
    override val restrictions
        : zio.aws.location.model.ApiKeyRestrictions.ReadOnly =
      zio.aws.location.model.ApiKeyRestrictions.wrap(impl.restrictions())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeKeyResponse
  ): zio.aws.location.model.DescribeKeyResponse.ReadOnly = new Wrapper(impl)
}
