package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DescribeMapRequest(mapName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeMapRequest = {
    import DescribeMapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeMapRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeMapRequest.ReadOnly =
    zio.aws.location.model.DescribeMapRequest.wrap(buildAwsValue())
}
object DescribeMapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeMapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeMapRequest =
      zio.aws.location.model.DescribeMapRequest(mapName)
    def mapName: ResourceName
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeMapRequest
  ) extends zio.aws.location.model.DescribeMapRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeMapRequest
  ): zio.aws.location.model.DescribeMapRequest.ReadOnly = new Wrapper(impl)
}
