package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DescribeRouteCalculatorRequest(calculatorName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest = {
    import DescribeRouteCalculatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DescribeRouteCalculatorRequest.ReadOnly =
    zio.aws.location.model.DescribeRouteCalculatorRequest.wrap(buildAwsValue())
}
object DescribeRouteCalculatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeRouteCalculatorRequest =
      zio.aws.location.model.DescribeRouteCalculatorRequest(calculatorName)
    def calculatorName: ResourceName
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest
  ) extends zio.aws.location.model.DescribeRouteCalculatorRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeRouteCalculatorRequest
  ): zio.aws.location.model.DescribeRouteCalculatorRequest.ReadOnly =
    new Wrapper(impl)
}
