package zio.aws.location.model
import zio.aws.location.model.primitives.{
  GeoArn,
  ResourceDescription,
  Timestamp,
  TagValue,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeRouteCalculatorResponse(
    calculatorArn: GeoArn,
    calculatorName: ResourceName,
    createTime: Timestamp,
    dataSource: String,
    description: ResourceDescription,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse = {
    import DescribeRouteCalculatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
      .builder()
      .calculatorArn(GeoArn.unwrap(calculatorArn): java.lang.String)
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .dataSource(dataSource: java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly =
    zio.aws.location.model.DescribeRouteCalculatorResponse.wrap(buildAwsValue())
}
object DescribeRouteCalculatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeRouteCalculatorResponse =
      zio.aws.location.model.DescribeRouteCalculatorResponse(
        calculatorArn,
        calculatorName,
        createTime,
        dataSource,
        description,
        pricingPlan.map(value => value),
        tags.map(value => value),
        updateTime
      )
    def calculatorArn: GeoArn
    def calculatorName: ResourceName
    def createTime: Timestamp
    def dataSource: String
    def description: ResourceDescription
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def tags: Optional[Map[TagKey, TagValue]]
    def updateTime: Timestamp
    def getCalculatorArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(calculatorArn)
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
  ) extends zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly {
    override val calculatorArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.calculatorArn())
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val dataSource: String = impl.dataSource(): String
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
  ): zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly =
    new Wrapper(impl)
}
