package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GeofenceGeometry(
    circle: Optional[zio.aws.location.model.Circle] = Optional.Absent,
    polygon: Optional[Iterable[Iterable[Iterable[Double]]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GeofenceGeometry = {
    import GeofenceGeometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GeofenceGeometry
      .builder()
      .optionallyWith(circle.map(value => value.buildAwsValue()))(_.circle)
      .optionallyWith(
        polygon.map(value =>
          value.map { item =>
            item.map { item =>
              item.map { item =>
                item: java.lang.Double
              }.asJavaCollection
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.polygon)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GeofenceGeometry.ReadOnly =
    zio.aws.location.model.GeofenceGeometry.wrap(buildAwsValue())
}
object GeofenceGeometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GeofenceGeometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GeofenceGeometry =
      zio.aws.location.model.GeofenceGeometry(
        circle.map(value => value.asEditable),
        polygon.map(value => value)
      )
    def circle: Optional[zio.aws.location.model.Circle.ReadOnly]
    def polygon: Optional[List[List[List[Double]]]]
    def getCircle: ZIO[Any, AwsError, zio.aws.location.model.Circle.ReadOnly] =
      AwsError.unwrapOptionField("circle", circle)
    def getPolygon: ZIO[Any, AwsError, List[List[List[Double]]]] =
      AwsError.unwrapOptionField("polygon", polygon)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GeofenceGeometry
  ) extends zio.aws.location.model.GeofenceGeometry.ReadOnly {
    override val circle: Optional[zio.aws.location.model.Circle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.circle())
        .map(value => zio.aws.location.model.Circle.wrap(value))
    override val polygon: Optional[List[List[List[Double]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.polygon())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item.asScala.map { item =>
                item: Double
              }.toList
            }.toList
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GeofenceGeometry
  ): zio.aws.location.model.GeofenceGeometry.ReadOnly = new Wrapper(impl)
}
