package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class GetDevicePositionHistoryResponse(
    devicePositions: Iterable[zio.aws.location.model.DevicePosition],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse = {
    import GetDevicePositionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse
      .builder()
      .devicePositions(devicePositions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly =
    zio.aws.location.model.GetDevicePositionHistoryResponse
      .wrap(buildAwsValue())
}
object GetDevicePositionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetDevicePositionHistoryResponse =
      zio.aws.location.model.GetDevicePositionHistoryResponse(
        devicePositions.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def devicePositions: List[zio.aws.location.model.DevicePosition.ReadOnly]
    def nextToken: Optional[Token]
    def getDevicePositions: ZIO[Any, Nothing, List[
      zio.aws.location.model.DevicePosition.ReadOnly
    ]] = ZIO.succeed(devicePositions)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse
  ) extends zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly {
    override val devicePositions
        : List[zio.aws.location.model.DevicePosition.ReadOnly] = impl
      .devicePositions()
      .asScala
      .map { item =>
        zio.aws.location.model.DevicePosition.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse
  ): zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
