package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  ResourceName,
  ApiKey,
  GetMapSpritesRequestFileNameString
}
import scala.jdk.CollectionConverters._
final case class GetMapSpritesRequest(
    fileName: GetMapSpritesRequestFileNameString,
    key: Optional[ApiKey] = Optional.Absent,
    mapName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapSpritesRequest = {
    import GetMapSpritesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapSpritesRequest
      .builder()
      .fileName(
        GetMapSpritesRequestFileNameString.unwrap(fileName): java.lang.String
      )
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapSpritesRequest.ReadOnly =
    zio.aws.location.model.GetMapSpritesRequest.wrap(buildAwsValue())
}
object GetMapSpritesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapSpritesRequest =
      zio.aws.location.model
        .GetMapSpritesRequest(fileName, key.map(value => value), mapName)
    def fileName: GetMapSpritesRequestFileNameString
    def key: Optional[ApiKey]
    def mapName: ResourceName
    def getFileName: ZIO[Any, Nothing, GetMapSpritesRequestFileNameString] =
      ZIO.succeed(fileName)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ) extends zio.aws.location.model.GetMapSpritesRequest.ReadOnly {
    override val fileName: GetMapSpritesRequestFileNameString =
      zio.aws.location.model.primitives
        .GetMapSpritesRequestFileNameString(impl.fileName())
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ): zio.aws.location.model.GetMapSpritesRequest.ReadOnly = new Wrapper(impl)
}
