package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{ResourceName, ApiKey}
import scala.jdk.CollectionConverters._
final case class GetMapStyleDescriptorRequest(
    key: Optional[ApiKey] = Optional.Absent,
    mapName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest = {
    import GetMapStyleDescriptorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
      .builder()
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly =
    zio.aws.location.model.GetMapStyleDescriptorRequest.wrap(buildAwsValue())
}
object GetMapStyleDescriptorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapStyleDescriptorRequest =
      zio.aws.location.model
        .GetMapStyleDescriptorRequest(key.map(value => value), mapName)
    def key: Optional[ApiKey]
    def mapName: ResourceName
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ) extends zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly {
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ): zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly = new Wrapper(
    impl
  )
}
