package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPlaceResponse(place: zio.aws.location.model.Place) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetPlaceResponse = {
    import GetPlaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetPlaceResponse
      .builder()
      .place(place.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetPlaceResponse.ReadOnly =
    zio.aws.location.model.GetPlaceResponse.wrap(buildAwsValue())
}
object GetPlaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetPlaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetPlaceResponse =
      zio.aws.location.model.GetPlaceResponse(place.asEditable)
    def place: zio.aws.location.model.Place.ReadOnly
    def getPlace: ZIO[Any, Nothing, zio.aws.location.model.Place.ReadOnly] =
      ZIO.succeed(place)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetPlaceResponse
  ) extends zio.aws.location.model.GetPlaceResponse.ReadOnly {
    override val place: zio.aws.location.model.Place.ReadOnly =
      zio.aws.location.model.Place.wrap(impl.place())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetPlaceResponse
  ): zio.aws.location.model.GetPlaceResponse.ReadOnly = new Wrapper(impl)
}
