package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  LegDurationSecondsDouble,
  LegDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class Leg(
    distance: LegDistanceDouble,
    durationSeconds: LegDurationSecondsDouble,
    endPosition: Iterable[Double],
    geometry: Optional[zio.aws.location.model.LegGeometry] = Optional.Absent,
    startPosition: Iterable[Double],
    steps: Iterable[zio.aws.location.model.Step]
) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Leg = {
    import Leg.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Leg
      .builder()
      .distance(LegDistanceDouble.unwrap(distance): java.lang.Double)
      .durationSeconds(
        LegDurationSecondsDouble.unwrap(durationSeconds): java.lang.Double
      )
      .endPosition(endPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .startPosition(startPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.Leg.ReadOnly =
    zio.aws.location.model.Leg.wrap(buildAwsValue())
}
object Leg {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Leg] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Leg = zio.aws.location.model.Leg(
      distance,
      durationSeconds,
      endPosition,
      geometry.map(value => value.asEditable),
      startPosition,
      steps.map { item =>
        item.asEditable
      }
    )
    def distance: LegDistanceDouble
    def durationSeconds: LegDurationSecondsDouble
    def endPosition: List[Double]
    def geometry: Optional[zio.aws.location.model.LegGeometry.ReadOnly]
    def startPosition: List[Double]
    def steps: List[zio.aws.location.model.Step.ReadOnly]
    def getDistance: ZIO[Any, Nothing, LegDistanceDouble] =
      ZIO.succeed(distance)
    def getDurationSeconds: ZIO[Any, Nothing, LegDurationSecondsDouble] =
      ZIO.succeed(durationSeconds)
    def getEndPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(endPosition)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.location.model.LegGeometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
    def getStartPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(startPosition)
    def getSteps
        : ZIO[Any, Nothing, List[zio.aws.location.model.Step.ReadOnly]] =
      ZIO.succeed(steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Leg
  ) extends zio.aws.location.model.Leg.ReadOnly {
    override val distance: LegDistanceDouble =
      zio.aws.location.model.primitives.LegDistanceDouble(impl.distance())
    override val durationSeconds: LegDurationSecondsDouble =
      zio.aws.location.model.primitives
        .LegDurationSecondsDouble(impl.durationSeconds())
    override val endPosition: List[Double] = impl
      .endPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val geometry
        : Optional[zio.aws.location.model.LegGeometry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geometry())
        .map(value => zio.aws.location.model.LegGeometry.wrap(value))
    override val startPosition: List[Double] = impl
      .startPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val steps: List[zio.aws.location.model.Step.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.location.model.Step.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Leg
  ): zio.aws.location.model.Leg.ReadOnly = new Wrapper(impl)
}
