package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LegGeometry(
    lineString: Optional[Iterable[Iterable[Double]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.LegGeometry = {
    import LegGeometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.LegGeometry
      .builder()
      .optionallyWith(
        lineString.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.Double
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.lineString)
      .build()
  }
  def asReadOnly: zio.aws.location.model.LegGeometry.ReadOnly =
    zio.aws.location.model.LegGeometry.wrap(buildAwsValue())
}
object LegGeometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.LegGeometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.LegGeometry =
      zio.aws.location.model.LegGeometry(lineString.map(value => value))
    def lineString: Optional[List[List[Double]]]
    def getLineString: ZIO[Any, AwsError, List[List[Double]]] =
      AwsError.unwrapOptionField("lineString", lineString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.LegGeometry
  ) extends zio.aws.location.model.LegGeometry.ReadOnly {
    override val lineString: Optional[List[List[Double]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineString())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item: Double
            }.toList
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.LegGeometry
  ): zio.aws.location.model.LegGeometry.ReadOnly = new Wrapper(impl)
}
