package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  ListGeofenceCollectionsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGeofenceCollectionsRequest(
    maxResults: Optional[ListGeofenceCollectionsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest = {
    import ListGeofenceCollectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListGeofenceCollectionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ListGeofenceCollectionsRequest.ReadOnly =
    zio.aws.location.model.ListGeofenceCollectionsRequest.wrap(buildAwsValue())
}
object ListGeofenceCollectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListGeofenceCollectionsRequest =
      zio.aws.location.model.ListGeofenceCollectionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListGeofenceCollectionsRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def getMaxResults
        : ZIO[Any, AwsError, ListGeofenceCollectionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest
  ) extends zio.aws.location.model.ListGeofenceCollectionsRequest.ReadOnly {
    override val maxResults
        : Optional[ListGeofenceCollectionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListGeofenceCollectionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListGeofenceCollectionsRequest
  ): zio.aws.location.model.ListGeofenceCollectionsRequest.ReadOnly =
    new Wrapper(impl)
}
