package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  ListKeysRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKeysRequest(
    filter: Optional[zio.aws.location.model.ApiKeyFilter] = Optional.Absent,
    maxResults: Optional[ListKeysRequestMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListKeysRequest = {
    import ListKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListKeysRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value =>
          ListKeysRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListKeysRequest.ReadOnly =
    zio.aws.location.model.ListKeysRequest.wrap(buildAwsValue())
}
object ListKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListKeysRequest =
      zio.aws.location.model.ListKeysRequest(
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[zio.aws.location.model.ApiKeyFilter.ReadOnly]
    def maxResults: Optional[ListKeysRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def getFilter
        : ZIO[Any, AwsError, zio.aws.location.model.ApiKeyFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, ListKeysRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListKeysRequest
  ) extends zio.aws.location.model.ListKeysRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.location.model.ApiKeyFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.location.model.ApiKeyFilter.wrap(value))
    override val maxResults: Optional[ListKeysRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListKeysRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListKeysRequest
  ): zio.aws.location.model.ListKeysRequest.ReadOnly = new Wrapper(impl)
}
