package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListMapsResponse(
    entries: Iterable[zio.aws.location.model.ListMapsResponseEntry],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListMapsResponse = {
    import ListMapsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListMapsResponse
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListMapsResponse.ReadOnly =
    zio.aws.location.model.ListMapsResponse.wrap(buildAwsValue())
}
object ListMapsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListMapsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListMapsResponse =
      zio.aws.location.model.ListMapsResponse(
        entries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entries: List[zio.aws.location.model.ListMapsResponseEntry.ReadOnly]
    def nextToken: Optional[Token]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.location.model.ListMapsResponseEntry.ReadOnly
    ]] = ZIO.succeed(entries)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListMapsResponse
  ) extends zio.aws.location.model.ListMapsResponse.ReadOnly {
    override val entries
        : List[zio.aws.location.model.ListMapsResponseEntry.ReadOnly] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.location.model.ListMapsResponseEntry.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListMapsResponse
  ): zio.aws.location.model.ListMapsResponse.ReadOnly = new Wrapper(impl)
}
