package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{MapStyle, CountryCode3}
import scala.jdk.CollectionConverters._
final case class MapConfiguration(
    politicalView: Optional[CountryCode3] = Optional.Absent,
    style: MapStyle
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.MapConfiguration = {
    import MapConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.MapConfiguration
      .builder()
      .optionallyWith(
        politicalView.map(value => CountryCode3.unwrap(value): java.lang.String)
      )(_.politicalView)
      .style(MapStyle.unwrap(style): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.MapConfiguration.ReadOnly =
    zio.aws.location.model.MapConfiguration.wrap(buildAwsValue())
}
object MapConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.MapConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.MapConfiguration =
      zio.aws.location.model
        .MapConfiguration(politicalView.map(value => value), style)
    def politicalView: Optional[CountryCode3]
    def style: MapStyle
    def getPoliticalView: ZIO[Any, AwsError, CountryCode3] =
      AwsError.unwrapOptionField("politicalView", politicalView)
    def getStyle: ZIO[Any, Nothing, MapStyle] = ZIO.succeed(style)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.MapConfiguration
  ) extends zio.aws.location.model.MapConfiguration.ReadOnly {
    override val politicalView: Optional[CountryCode3] = zio.aws.core.internal
      .optionalFromNullable(impl.politicalView())
      .map(value => zio.aws.location.model.primitives.CountryCode3(value))
    override val style: MapStyle =
      zio.aws.location.model.primitives.MapStyle(impl.style())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.MapConfiguration
  ): zio.aws.location.model.MapConfiguration.ReadOnly = new Wrapper(impl)
}
