package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.CountryCode3OrEmpty
import scala.jdk.CollectionConverters._
final case class MapConfigurationUpdate(
    politicalView: Optional[CountryCode3OrEmpty] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.MapConfigurationUpdate = {
    import MapConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.MapConfigurationUpdate
      .builder()
      .optionallyWith(
        politicalView.map(value =>
          CountryCode3OrEmpty.unwrap(value): java.lang.String
        )
      )(_.politicalView)
      .build()
  }
  def asReadOnly: zio.aws.location.model.MapConfigurationUpdate.ReadOnly =
    zio.aws.location.model.MapConfigurationUpdate.wrap(buildAwsValue())
}
object MapConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.MapConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.MapConfigurationUpdate =
      zio.aws.location.model
        .MapConfigurationUpdate(politicalView.map(value => value))
    def politicalView: Optional[CountryCode3OrEmpty]
    def getPoliticalView: ZIO[Any, AwsError, CountryCode3OrEmpty] =
      AwsError.unwrapOptionField("politicalView", politicalView)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.MapConfigurationUpdate
  ) extends zio.aws.location.model.MapConfigurationUpdate.ReadOnly {
    override val politicalView: Optional[CountryCode3OrEmpty] =
      zio.aws.core.internal
        .optionalFromNullable(impl.politicalView())
        .map(value =>
          zio.aws.location.model.primitives.CountryCode3OrEmpty(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.MapConfigurationUpdate
  ): zio.aws.location.model.MapConfigurationUpdate.ReadOnly = new Wrapper(impl)
}
