package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PropertyMapValueString,
  PropertyMapKeyString,
  Id,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class PutGeofenceRequest(
    collectionName: ResourceName,
    geofenceId: Id,
    geofenceProperties: Optional[
      Map[PropertyMapKeyString, PropertyMapValueString]
    ] = Optional.Absent,
    geometry: zio.aws.location.model.GeofenceGeometry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.PutGeofenceRequest = {
    import PutGeofenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.PutGeofenceRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .optionallyWith(
        geofenceProperties.map(value =>
          value
            .map({ case (key, value) =>
              (PropertyMapKeyString
                .unwrap(key): java.lang.String) -> (PropertyMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.geofenceProperties)
      .geometry(geometry.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.PutGeofenceRequest.ReadOnly =
    zio.aws.location.model.PutGeofenceRequest.wrap(buildAwsValue())
}
object PutGeofenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.PutGeofenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.PutGeofenceRequest =
      zio.aws.location.model.PutGeofenceRequest(
        collectionName,
        geofenceId,
        geofenceProperties.map(value => value),
        geometry.asEditable
      )
    def collectionName: ResourceName
    def geofenceId: Id
    def geofenceProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]]
    def geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
    def getGeofenceProperties: ZIO[Any, AwsError, Map[
      PropertyMapKeyString,
      PropertyMapValueString
    ]] = AwsError.unwrapOptionField("geofenceProperties", geofenceProperties)
    def getGeometry
        : ZIO[Any, Nothing, zio.aws.location.model.GeofenceGeometry.ReadOnly] =
      ZIO.succeed(geometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.PutGeofenceRequest
  ) extends zio.aws.location.model.PutGeofenceRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
    override val geofenceProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geofenceProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.location.model.primitives
                .PropertyMapKeyString(key) -> zio.aws.location.model.primitives
                .PropertyMapValueString(value)
            })
            .toMap
        )
    override val geometry: zio.aws.location.model.GeofenceGeometry.ReadOnly =
      zio.aws.location.model.GeofenceGeometry.wrap(impl.geometry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.PutGeofenceRequest
  ): zio.aws.location.model.PutGeofenceRequest.ReadOnly = new Wrapper(impl)
}
