package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Id, Timestamp}
import scala.jdk.CollectionConverters._
final case class PutGeofenceResponse(
    createTime: Timestamp,
    geofenceId: Id,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.PutGeofenceResponse = {
    import PutGeofenceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.PutGeofenceResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.PutGeofenceResponse.ReadOnly =
    zio.aws.location.model.PutGeofenceResponse.wrap(buildAwsValue())
}
object PutGeofenceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.PutGeofenceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.PutGeofenceResponse =
      zio.aws.location.model
        .PutGeofenceResponse(createTime, geofenceId, updateTime)
    def createTime: Timestamp
    def geofenceId: Id
    def updateTime: Timestamp
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.PutGeofenceResponse
  ) extends zio.aws.location.model.PutGeofenceResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.PutGeofenceResponse
  ): zio.aws.location.model.PutGeofenceResponse.ReadOnly = new Wrapper(impl)
}
