package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PlaceSupplementalCategory,
  PlaceId,
  PlaceCategory
}
import scala.jdk.CollectionConverters._
final case class SearchForSuggestionsResult(
    categories: Optional[Iterable[PlaceCategory]] = Optional.Absent,
    placeId: Optional[PlaceId] = Optional.Absent,
    supplementalCategories: Optional[Iterable[PlaceSupplementalCategory]] =
      Optional.Absent,
    text: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchForSuggestionsResult = {
    import SearchForSuggestionsResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
      .builder()
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            PlaceCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.categories)
      .optionallyWith(
        placeId.map(value => PlaceId.unwrap(value): java.lang.String)
      )(_.placeId)
      .optionallyWith(
        supplementalCategories.map(value =>
          value.map { item =>
            PlaceSupplementalCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supplementalCategories)
      .text(text: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.SearchForSuggestionsResult.ReadOnly =
    zio.aws.location.model.SearchForSuggestionsResult.wrap(buildAwsValue())
}
object SearchForSuggestionsResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchForSuggestionsResult =
      zio.aws.location.model.SearchForSuggestionsResult(
        categories.map(value => value),
        placeId.map(value => value),
        supplementalCategories.map(value => value),
        text
      )
    def categories: Optional[List[PlaceCategory]]
    def placeId: Optional[PlaceId]
    def supplementalCategories: Optional[List[PlaceSupplementalCategory]]
    def text: String
    def getCategories: ZIO[Any, AwsError, List[PlaceCategory]] =
      AwsError.unwrapOptionField("categories", categories)
    def getPlaceId: ZIO[Any, AwsError, PlaceId] =
      AwsError.unwrapOptionField("placeId", placeId)
    def getSupplementalCategories
        : ZIO[Any, AwsError, List[PlaceSupplementalCategory]] = AwsError
      .unwrapOptionField("supplementalCategories", supplementalCategories)
    def getText: ZIO[Any, Nothing, String] = ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
  ) extends zio.aws.location.model.SearchForSuggestionsResult.ReadOnly {
    override val categories: Optional[List[PlaceCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.categories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.PlaceCategory(item)
          }.toList
        )
    override val placeId: Optional[PlaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.placeId())
      .map(value => zio.aws.location.model.primitives.PlaceId(value))
    override val supplementalCategories
        : Optional[List[PlaceSupplementalCategory]] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementalCategories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.location.model.primitives.PlaceSupplementalCategory(item)
        }.toList
      )
    override val text: String = impl.text(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchForSuggestionsResult
  ): zio.aws.location.model.SearchForSuggestionsResult.ReadOnly = new Wrapper(
    impl
  )
}
