package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  SearchForTextResultRelevanceDouble,
  PlaceId,
  SearchForTextResultDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class SearchForTextResult(
    distance: Optional[SearchForTextResultDistanceDouble] = Optional.Absent,
    place: zio.aws.location.model.Place,
    placeId: Optional[PlaceId] = Optional.Absent,
    relevance: Optional[SearchForTextResultRelevanceDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchForTextResult = {
    import SearchForTextResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchForTextResult
      .builder()
      .optionallyWith(
        distance.map(value =>
          SearchForTextResultDistanceDouble.unwrap(value): java.lang.Double
        )
      )(_.distance)
      .place(place.buildAwsValue())
      .optionallyWith(
        placeId.map(value => PlaceId.unwrap(value): java.lang.String)
      )(_.placeId)
      .optionallyWith(
        relevance.map(value =>
          SearchForTextResultRelevanceDouble.unwrap(value): java.lang.Double
        )
      )(_.relevance)
      .build()
  }
  def asReadOnly: zio.aws.location.model.SearchForTextResult.ReadOnly =
    zio.aws.location.model.SearchForTextResult.wrap(buildAwsValue())
}
object SearchForTextResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchForTextResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchForTextResult =
      zio.aws.location.model.SearchForTextResult(
        distance.map(value => value),
        place.asEditable,
        placeId.map(value => value),
        relevance.map(value => value)
      )
    def distance: Optional[SearchForTextResultDistanceDouble]
    def place: zio.aws.location.model.Place.ReadOnly
    def placeId: Optional[PlaceId]
    def relevance: Optional[SearchForTextResultRelevanceDouble]
    def getDistance: ZIO[Any, AwsError, SearchForTextResultDistanceDouble] =
      AwsError.unwrapOptionField("distance", distance)
    def getPlace: ZIO[Any, Nothing, zio.aws.location.model.Place.ReadOnly] =
      ZIO.succeed(place)
    def getPlaceId: ZIO[Any, AwsError, PlaceId] =
      AwsError.unwrapOptionField("placeId", placeId)
    def getRelevance: ZIO[Any, AwsError, SearchForTextResultRelevanceDouble] =
      AwsError.unwrapOptionField("relevance", relevance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchForTextResult
  ) extends zio.aws.location.model.SearchForTextResult.ReadOnly {
    override val distance: Optional[SearchForTextResultDistanceDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distance())
        .map(value =>
          zio.aws.location.model.primitives
            .SearchForTextResultDistanceDouble(value)
        )
    override val place: zio.aws.location.model.Place.ReadOnly =
      zio.aws.location.model.Place.wrap(impl.place())
    override val placeId: Optional[PlaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.placeId())
      .map(value => zio.aws.location.model.primitives.PlaceId(value))
    override val relevance: Optional[SearchForTextResultRelevanceDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relevance())
        .map(value =>
          zio.aws.location.model.primitives
            .SearchForTextResultRelevanceDouble(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchForTextResult
  ): zio.aws.location.model.SearchForTextResult.ReadOnly = new Wrapper(impl)
}
