package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForSuggestionsResponse(
    results: Iterable[zio.aws.location.model.SearchForSuggestionsResult],
    summary: zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse = {
    import SearchPlaceIndexForSuggestionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
      .builder()
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .summary(summary.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForSuggestionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse(
        results.map { item =>
          item.asEditable
        },
        summary.asEditable
      )
    def results
        : List[zio.aws.location.model.SearchForSuggestionsResult.ReadOnly]
    def summary
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly
    def getResults: ZIO[Any, Nothing, List[
      zio.aws.location.model.SearchForSuggestionsResult.ReadOnly
    ]] = ZIO.succeed(results)
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly
    ] = ZIO.succeed(summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
  ) extends zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly {
    override val results
        : List[zio.aws.location.model.SearchForSuggestionsResult.ReadOnly] =
      impl
        .results()
        .asScala
        .map { item =>
          zio.aws.location.model.SearchForSuggestionsResult.wrap(item)
        }
        .toList
    override val summary
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary
        .wrap(impl.summary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsResponse
  ): zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly =
    new Wrapper(impl)
}
