package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  PlaceCategory,
  Integer,
  LanguageTag,
  CountryCode,
  SensitiveString
}
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForSuggestionsSummary(
    biasPosition: Optional[Iterable[Double]] = Optional.Absent,
    dataSource: String,
    filterBBox: Optional[Iterable[Double]] = Optional.Absent,
    filterCategories: Optional[Iterable[PlaceCategory]] = Optional.Absent,
    filterCountries: Optional[Iterable[CountryCode]] = Optional.Absent,
    language: Optional[LanguageTag] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    text: SensitiveString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary = {
    import SearchPlaceIndexForSuggestionsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
      .builder()
      .optionallyWith(
        biasPosition.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.biasPosition)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        filterBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.filterBBox)
      .optionallyWith(
        filterCategories.map(value =>
          value.map { item =>
            PlaceCategory.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCategories)
      .optionallyWith(
        filterCountries.map(value =>
          value.map { item =>
            CountryCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCountries)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .text(SensitiveString.unwrap(text): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForSuggestionsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary(
        biasPosition.map(value => value),
        dataSource,
        filterBBox.map(value => value),
        filterCategories.map(value => value),
        filterCountries.map(value => value),
        language.map(value => value),
        maxResults.map(value => value),
        text
      )
    def biasPosition: Optional[List[Double]]
    def dataSource: String
    def filterBBox: Optional[List[Double]]
    def filterCategories: Optional[List[PlaceCategory]]
    def filterCountries: Optional[List[CountryCode]]
    def language: Optional[LanguageTag]
    def maxResults: Optional[Integer]
    def text: SensitiveString
    def getBiasPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("biasPosition", biasPosition)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getFilterBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("filterBBox", filterBBox)
    def getFilterCategories: ZIO[Any, AwsError, List[PlaceCategory]] =
      AwsError.unwrapOptionField("filterCategories", filterCategories)
    def getFilterCountries: ZIO[Any, AwsError, List[CountryCode]] =
      AwsError.unwrapOptionField("filterCountries", filterCountries)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getText: ZIO[Any, Nothing, SensitiveString] = ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ) extends zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly {
    override val biasPosition: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.biasPosition())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val dataSource: String = impl.dataSource(): String
    override val filterBBox: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.filterBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterCategories: Optional[List[PlaceCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.PlaceCategory(item)
          }.toList
        )
    override val filterCountries: Optional[List[CountryCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCountries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.CountryCode(item)
          }.toList
        )
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val text: SensitiveString =
      zio.aws.location.model.primitives.SensitiveString(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsSummary
  ): zio.aws.location.model.SearchPlaceIndexForSuggestionsSummary.ReadOnly =
    new Wrapper(impl)
}
