package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForTextResponse(
    results: Iterable[zio.aws.location.model.SearchForTextResult],
    summary: zio.aws.location.model.SearchPlaceIndexForTextSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse = {
    import SearchPlaceIndexForTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
      .builder()
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .summary(summary.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForTextResponse.wrap(buildAwsValue())
}
object SearchPlaceIndexForTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForTextResponse =
      zio.aws.location.model.SearchPlaceIndexForTextResponse(
        results.map { item =>
          item.asEditable
        },
        summary.asEditable
      )
    def results: List[zio.aws.location.model.SearchForTextResult.ReadOnly]
    def summary: zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly
    def getResults: ZIO[Any, Nothing, List[
      zio.aws.location.model.SearchForTextResult.ReadOnly
    ]] = ZIO.succeed(results)
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly
    ] = ZIO.succeed(summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
  ) extends zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly {
    override val results
        : List[zio.aws.location.model.SearchForTextResult.ReadOnly] = impl
      .results()
      .asScala
      .map { item =>
        zio.aws.location.model.SearchForTextResult.wrap(item)
      }
      .toList
    override val summary
        : zio.aws.location.model.SearchPlaceIndexForTextSummary.ReadOnly =
      zio.aws.location.model.SearchPlaceIndexForTextSummary.wrap(impl.summary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForTextResponse
  ): zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly =
    new Wrapper(impl)
}
