package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.location.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.location.model.Status
  ): zio.aws.location.model.Status = value match {
    case software.amazon.awssdk.services.location.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.Status.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.location.model.Status.EXPIRED =>
      val r = Expired
      r
  }
  case object unknownToSdkVersion extends zio.aws.location.model.Status {
    override def unwrap: software.amazon.awssdk.services.location.model.Status =
      software.amazon.awssdk.services.location.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.location.model.Status {
    override def unwrap: software.amazon.awssdk.services.location.model.Status =
      software.amazon.awssdk.services.location.model.Status.ACTIVE
  }
  case object Expired extends zio.aws.location.model.Status {
    override def unwrap: software.amazon.awssdk.services.location.model.Status =
      software.amazon.awssdk.services.location.model.Status.EXPIRED
  }
}
