package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{TagValue, TagKey, Arn}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.TagResourceRequest.ReadOnly =
    zio.aws.location.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.TagResourceRequest =
      zio.aws.location.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.TagResourceRequest
  ) extends zio.aws.location.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.location.model.primitives
          .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.TagResourceRequest
  ): zio.aws.location.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
