package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait TravelMode {
  def unwrap: software.amazon.awssdk.services.location.model.TravelMode
}
object TravelMode {
  def wrap(
      value: software.amazon.awssdk.services.location.model.TravelMode
  ): zio.aws.location.model.TravelMode = value match {
    case software.amazon.awssdk.services.location.model.TravelMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.TravelMode.CAR =>
      val r = Car
      r
    case software.amazon.awssdk.services.location.model.TravelMode.TRUCK =>
      val r = Truck
      r
    case software.amazon.awssdk.services.location.model.TravelMode.WALKING =>
      val r = Walking
      r
    case software.amazon.awssdk.services.location.model.TravelMode.BICYCLE =>
      val r = Bicycle
      r
    case software.amazon.awssdk.services.location.model.TravelMode.MOTORCYCLE =>
      val r = Motorcycle
      r
  }
  case object unknownToSdkVersion extends zio.aws.location.model.TravelMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.TravelMode =
      software.amazon.awssdk.services.location.model.TravelMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Car extends zio.aws.location.model.TravelMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.TravelMode =
      software.amazon.awssdk.services.location.model.TravelMode.CAR
  }
  case object Truck extends zio.aws.location.model.TravelMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.TravelMode =
      software.amazon.awssdk.services.location.model.TravelMode.TRUCK
  }
  case object Walking extends zio.aws.location.model.TravelMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.TravelMode =
      software.amazon.awssdk.services.location.model.TravelMode.WALKING
  }
  case object Bicycle extends zio.aws.location.model.TravelMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.TravelMode =
      software.amazon.awssdk.services.location.model.TravelMode.BICYCLE
  }
  case object Motorcycle extends zio.aws.location.model.TravelMode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.TravelMode =
      software.amazon.awssdk.services.location.model.TravelMode.MOTORCYCLE
  }
}
