package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, GeoArn}
import scala.jdk.CollectionConverters._
final case class UpdateRouteCalculatorResponse(
    calculatorArn: GeoArn,
    calculatorName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse = {
    import UpdateRouteCalculatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse
      .builder()
      .calculatorArn(GeoArn.unwrap(calculatorArn): java.lang.String)
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly =
    zio.aws.location.model.UpdateRouteCalculatorResponse.wrap(buildAwsValue())
}
object UpdateRouteCalculatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateRouteCalculatorResponse =
      zio.aws.location.model.UpdateRouteCalculatorResponse(
        calculatorArn,
        calculatorName,
        updateTime
      )
    def calculatorArn: GeoArn
    def calculatorName: ResourceName
    def updateTime: Timestamp
    def getCalculatorArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(calculatorArn)
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse
  ) extends zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly {
    override val calculatorArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.calculatorArn())
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateRouteCalculatorResponse
  ): zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly =
    new Wrapper(impl)
}
