package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  RefererPattern,
  GeoArnV2,
  ApiKeyAction
}
import scala.jdk.CollectionConverters._
final case class ApiKeyRestrictions(
    allowActions: Iterable[ApiKeyAction],
    allowResources: Iterable[GeoArnV2],
    allowReferers: Optional[Iterable[RefererPattern]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ApiKeyRestrictions = {
    import ApiKeyRestrictions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ApiKeyRestrictions
      .builder()
      .allowActions(allowActions.map { item =>
        ApiKeyAction.unwrap(item): java.lang.String
      }.asJavaCollection)
      .allowResources(allowResources.map { item =>
        GeoArnV2.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        allowReferers.map(value =>
          value.map { item =>
            RefererPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowReferers)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ApiKeyRestrictions.ReadOnly =
    zio.aws.location.model.ApiKeyRestrictions.wrap(buildAwsValue())
}
object ApiKeyRestrictions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ApiKeyRestrictions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ApiKeyRestrictions =
      zio.aws.location.model.ApiKeyRestrictions(
        allowActions,
        allowResources,
        allowReferers.map(value => value)
      )
    def allowActions: List[ApiKeyAction]
    def allowResources: List[GeoArnV2]
    def allowReferers: Optional[List[RefererPattern]]
    def getAllowActions: ZIO[Any, Nothing, List[ApiKeyAction]] =
      ZIO.succeed(allowActions)
    def getAllowResources: ZIO[Any, Nothing, List[GeoArnV2]] =
      ZIO.succeed(allowResources)
    def getAllowReferers: ZIO[Any, AwsError, List[RefererPattern]] =
      AwsError.unwrapOptionField("allowReferers", allowReferers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ApiKeyRestrictions
  ) extends zio.aws.location.model.ApiKeyRestrictions.ReadOnly {
    override val allowActions: List[ApiKeyAction] = impl
      .allowActions()
      .asScala
      .map { item =>
        zio.aws.location.model.primitives.ApiKeyAction(item)
      }
      .toList
    override val allowResources: List[GeoArnV2] = impl
      .allowResources()
      .asScala
      .map { item =>
        zio.aws.location.model.primitives.GeoArnV2(item)
      }
      .toList
    override val allowReferers: Optional[List[RefererPattern]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowReferers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.RefererPattern(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ApiKeyRestrictions
  ): zio.aws.location.model.ApiKeyRestrictions.ReadOnly = new Wrapper(impl)
}
