package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{Arn, ResourceName}
import scala.jdk.CollectionConverters._
final case class AssociateTrackerConsumerRequest(
    trackerName: ResourceName,
    consumerArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest = {
    import AssociateTrackerConsumerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .consumerArn(Arn.unwrap(consumerArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.AssociateTrackerConsumerRequest.ReadOnly =
    zio.aws.location.model.AssociateTrackerConsumerRequest.wrap(buildAwsValue())
}
object AssociateTrackerConsumerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.AssociateTrackerConsumerRequest =
      zio.aws.location.model
        .AssociateTrackerConsumerRequest(trackerName, consumerArn)
    def trackerName: ResourceName
    def consumerArn: Arn
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getConsumerArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(consumerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest
  ) extends zio.aws.location.model.AssociateTrackerConsumerRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val consumerArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.consumerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.AssociateTrackerConsumerRequest
  ): zio.aws.location.model.AssociateTrackerConsumerRequest.ReadOnly =
    new Wrapper(impl)
}
