package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class BatchDeleteDevicePositionHistoryError(
    deviceId: Id,
    error: zio.aws.location.model.BatchItemError
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryError = {
    import BatchDeleteDevicePositionHistoryError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryError
      .builder()
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .error(error.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchDeleteDevicePositionHistoryError.ReadOnly =
    zio.aws.location.model.BatchDeleteDevicePositionHistoryError
      .wrap(buildAwsValue())
}
object BatchDeleteDevicePositionHistoryError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.BatchDeleteDevicePositionHistoryError =
      zio.aws.location.model
        .BatchDeleteDevicePositionHistoryError(deviceId, error.asEditable)
    def deviceId: Id
    def error: zio.aws.location.model.BatchItemError.ReadOnly
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getError
        : ZIO[Any, Nothing, zio.aws.location.model.BatchItemError.ReadOnly] =
      ZIO.succeed(error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryError
  ) extends zio.aws.location.model.BatchDeleteDevicePositionHistoryError.ReadOnly {
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val error: zio.aws.location.model.BatchItemError.ReadOnly =
      zio.aws.location.model.BatchItemError.wrap(impl.error())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryError
  ): zio.aws.location.model.BatchDeleteDevicePositionHistoryError.ReadOnly =
    new Wrapper(impl)
}
