package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{Id, ResourceName}
import scala.jdk.CollectionConverters._
final case class BatchDeleteDevicePositionHistoryRequest(
    trackerName: ResourceName,
    deviceIds: Iterable[Id]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest = {
    import BatchDeleteDevicePositionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .deviceIds(deviceIds.map { item =>
        Id.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest.ReadOnly =
    zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest
      .wrap(buildAwsValue())
}
object BatchDeleteDevicePositionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest =
      zio.aws.location.model
        .BatchDeleteDevicePositionHistoryRequest(trackerName, deviceIds)
    def trackerName: ResourceName
    def deviceIds: List[Id]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getDeviceIds: ZIO[Any, Nothing, List[Id]] = ZIO.succeed(deviceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
  ) extends zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val deviceIds: List[Id] = impl
      .deviceIds()
      .asScala
      .map { item =>
        zio.aws.location.model.primitives.Id(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryRequest
  ): zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
