package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class BatchEvaluateGeofencesError(
    deviceId: Id,
    sampleTime: Timestamp,
    error: zio.aws.location.model.BatchItemError
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesError = {
    import BatchEvaluateGeofencesError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesError
      .builder()
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .error(error.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchEvaluateGeofencesError.ReadOnly =
    zio.aws.location.model.BatchEvaluateGeofencesError.wrap(buildAwsValue())
}
object BatchEvaluateGeofencesError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchEvaluateGeofencesError =
      zio.aws.location.model
        .BatchEvaluateGeofencesError(deviceId, sampleTime, error.asEditable)
    def deviceId: Id
    def sampleTime: Timestamp
    def error: zio.aws.location.model.BatchItemError.ReadOnly
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
    def getError
        : ZIO[Any, Nothing, zio.aws.location.model.BatchItemError.ReadOnly] =
      ZIO.succeed(error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesError
  ) extends zio.aws.location.model.BatchEvaluateGeofencesError.ReadOnly {
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
    override val error: zio.aws.location.model.BatchItemError.ReadOnly =
      zio.aws.location.model.BatchItemError.wrap(impl.error())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchEvaluateGeofencesError
  ): zio.aws.location.model.BatchEvaluateGeofencesError.ReadOnly = new Wrapper(
    impl
  )
}
