package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.Id
import scala.jdk.CollectionConverters._
final case class BatchPutGeofenceError(
    geofenceId: Id,
    error: zio.aws.location.model.BatchItemError
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchPutGeofenceError = {
    import BatchPutGeofenceError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchPutGeofenceError
      .builder()
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .error(error.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchPutGeofenceError.ReadOnly =
    zio.aws.location.model.BatchPutGeofenceError.wrap(buildAwsValue())
}
object BatchPutGeofenceError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchPutGeofenceError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchPutGeofenceError =
      zio.aws.location.model.BatchPutGeofenceError(geofenceId, error.asEditable)
    def geofenceId: Id
    def error: zio.aws.location.model.BatchItemError.ReadOnly
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
    def getError
        : ZIO[Any, Nothing, zio.aws.location.model.BatchItemError.ReadOnly] =
      ZIO.succeed(error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceError
  ) extends zio.aws.location.model.BatchPutGeofenceError.ReadOnly {
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
    override val error: zio.aws.location.model.BatchItemError.ReadOnly =
      zio.aws.location.model.BatchItemError.wrap(impl.error())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceError
  ): zio.aws.location.model.BatchPutGeofenceError.ReadOnly = new Wrapper(impl)
}
