package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class BatchPutGeofenceSuccess(
    geofenceId: Id,
    createTime: Timestamp,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchPutGeofenceSuccess = {
    import BatchPutGeofenceSuccess.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchPutGeofenceSuccess
      .builder()
      .geofenceId(Id.unwrap(geofenceId): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchPutGeofenceSuccess.ReadOnly =
    zio.aws.location.model.BatchPutGeofenceSuccess.wrap(buildAwsValue())
}
object BatchPutGeofenceSuccess {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchPutGeofenceSuccess
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchPutGeofenceSuccess =
      zio.aws.location.model
        .BatchPutGeofenceSuccess(geofenceId, createTime, updateTime)
    def geofenceId: Id
    def createTime: Timestamp
    def updateTime: Timestamp
    def getGeofenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(geofenceId)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceSuccess
  ) extends zio.aws.location.model.BatchPutGeofenceSuccess.ReadOnly {
    override val geofenceId: Id =
      zio.aws.location.model.primitives.Id(impl.geofenceId())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceSuccess
  ): zio.aws.location.model.BatchPutGeofenceSuccess.ReadOnly = new Wrapper(impl)
}
