package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class BatchUpdateDevicePositionError(
    deviceId: Id,
    sampleTime: Timestamp,
    error: zio.aws.location.model.BatchItemError
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError = {
    import BatchUpdateDevicePositionError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError
      .builder()
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .error(error.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchUpdateDevicePositionError.ReadOnly =
    zio.aws.location.model.BatchUpdateDevicePositionError.wrap(buildAwsValue())
}
object BatchUpdateDevicePositionError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchUpdateDevicePositionError =
      zio.aws.location.model
        .BatchUpdateDevicePositionError(deviceId, sampleTime, error.asEditable)
    def deviceId: Id
    def sampleTime: Timestamp
    def error: zio.aws.location.model.BatchItemError.ReadOnly
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
    def getError
        : ZIO[Any, Nothing, zio.aws.location.model.BatchItemError.ReadOnly] =
      ZIO.succeed(error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError
  ) extends zio.aws.location.model.BatchUpdateDevicePositionError.ReadOnly {
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
    override val error: zio.aws.location.model.BatchItemError.ReadOnly =
      zio.aws.location.model.BatchItemError.wrap(impl.error())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionError
  ): zio.aws.location.model.BatchUpdateDevicePositionError.ReadOnly =
    new Wrapper(impl)
}
