package zio.aws.location.model
import zio.aws.location.model.primitives.{ApiKey, Timestamp, ResourceName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CalculateRouteMatrixRequest(
    calculatorName: ResourceName,
    departurePositions: Iterable[Iterable[Double]],
    destinationPositions: Iterable[Iterable[Double]],
    travelMode: Optional[zio.aws.location.model.TravelMode] = Optional.Absent,
    departureTime: Optional[Timestamp] = Optional.Absent,
    departNow: Optional[Boolean] = Optional.Absent,
    distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      Optional.Absent,
    carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions
    ] = Optional.Absent,
    truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions
    ] = Optional.Absent,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest = {
    import CalculateRouteMatrixRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .departurePositions(departurePositions.map { item =>
        item.map { item =>
          item: java.lang.Double
        }.asJavaCollection
      }.asJavaCollection)
      .destinationPositions(destinationPositions.map { item =>
        item.map { item =>
          item: java.lang.Double
        }.asJavaCollection
      }.asJavaCollection)
      .optionallyWith(travelMode.map(value => value.unwrap))(_.travelMode)
      .optionallyWith(
        departureTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.departureTime)
      .optionallyWith(departNow.map(value => value: java.lang.Boolean))(
        _.departNow
      )
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .optionallyWith(carModeOptions.map(value => value.buildAwsValue()))(
        _.carModeOptions
      )
      .optionallyWith(truckModeOptions.map(value => value.buildAwsValue()))(
        _.truckModeOptions
      )
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteMatrixRequest.ReadOnly =
    zio.aws.location.model.CalculateRouteMatrixRequest.wrap(buildAwsValue())
}
object CalculateRouteMatrixRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteMatrixRequest =
      zio.aws.location.model.CalculateRouteMatrixRequest(
        calculatorName,
        departurePositions,
        destinationPositions,
        travelMode.map(value => value),
        departureTime.map(value => value),
        departNow.map(value => value),
        distanceUnit.map(value => value),
        carModeOptions.map(value => value.asEditable),
        truckModeOptions.map(value => value.asEditable),
        key.map(value => value)
      )
    def calculatorName: ResourceName
    def departurePositions: List[List[Double]]
    def destinationPositions: List[List[Double]]
    def travelMode: Optional[zio.aws.location.model.TravelMode]
    def departureTime: Optional[Timestamp]
    def departNow: Optional[Boolean]
    def distanceUnit: Optional[zio.aws.location.model.DistanceUnit]
    def carModeOptions
        : Optional[zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly]
    def truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ]
    def key: Optional[ApiKey]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getDeparturePositions: ZIO[Any, Nothing, List[List[Double]]] =
      ZIO.succeed(departurePositions)
    def getDestinationPositions: ZIO[Any, Nothing, List[List[Double]]] =
      ZIO.succeed(destinationPositions)
    def getTravelMode: ZIO[Any, AwsError, zio.aws.location.model.TravelMode] =
      AwsError.unwrapOptionField("travelMode", travelMode)
    def getDepartureTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("departureTime", departureTime)
    def getDepartNow: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("departNow", departNow)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.location.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
    def getCarModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("carModeOptions", carModeOptions)
    def getTruckModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("truckModeOptions", truckModeOptions)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
  ) extends zio.aws.location.model.CalculateRouteMatrixRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val departurePositions: List[List[Double]] = impl
      .departurePositions()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          item: Double
        }.toList
      }
      .toList
    override val destinationPositions: List[List[Double]] = impl
      .destinationPositions()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          item: Double
        }.toList
      }
      .toList
    override val travelMode: Optional[zio.aws.location.model.TravelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.travelMode())
        .map(value => zio.aws.location.model.TravelMode.wrap(value))
    override val departureTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.departureTime())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val departNow: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.departNow())
      .map(value => value: Boolean)
    override val distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distanceUnit())
        .map(value => zio.aws.location.model.DistanceUnit.wrap(value))
    override val carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.carModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteCarModeOptions.wrap(value)
      )
    override val truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.truckModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteTruckModeOptions.wrap(value)
      )
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
  ): zio.aws.location.model.CalculateRouteMatrixRequest.ReadOnly = new Wrapper(
    impl
  )
}
