package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  CalculateRouteMatrixSummaryErrorCountInteger,
  CalculateRouteMatrixSummaryRouteCountInteger
}
import scala.jdk.CollectionConverters._
final case class CalculateRouteMatrixSummary(
    dataSource: String,
    routeCount: CalculateRouteMatrixSummaryRouteCountInteger,
    errorCount: CalculateRouteMatrixSummaryErrorCountInteger,
    distanceUnit: zio.aws.location.model.DistanceUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary = {
    import CalculateRouteMatrixSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
      .builder()
      .dataSource(dataSource: java.lang.String)
      .routeCount(
        CalculateRouteMatrixSummaryRouteCountInteger.unwrap(routeCount): Integer
      )
      .errorCount(
        CalculateRouteMatrixSummaryErrorCountInteger.unwrap(errorCount): Integer
      )
      .distanceUnit(distanceUnit.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly =
    zio.aws.location.model.CalculateRouteMatrixSummary.wrap(buildAwsValue())
}
object CalculateRouteMatrixSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteMatrixSummary =
      zio.aws.location.model.CalculateRouteMatrixSummary(
        dataSource,
        routeCount,
        errorCount,
        distanceUnit
      )
    def dataSource: String
    def routeCount: CalculateRouteMatrixSummaryRouteCountInteger
    def errorCount: CalculateRouteMatrixSummaryErrorCountInteger
    def distanceUnit: zio.aws.location.model.DistanceUnit
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getRouteCount
        : ZIO[Any, Nothing, CalculateRouteMatrixSummaryRouteCountInteger] =
      ZIO.succeed(routeCount)
    def getErrorCount
        : ZIO[Any, Nothing, CalculateRouteMatrixSummaryErrorCountInteger] =
      ZIO.succeed(errorCount)
    def getDistanceUnit
        : ZIO[Any, Nothing, zio.aws.location.model.DistanceUnit] =
      ZIO.succeed(distanceUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
  ) extends zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly {
    override val dataSource: String = impl.dataSource(): String
    override val routeCount: CalculateRouteMatrixSummaryRouteCountInteger =
      zio.aws.location.model.primitives
        .CalculateRouteMatrixSummaryRouteCountInteger(impl.routeCount())
    override val errorCount: CalculateRouteMatrixSummaryErrorCountInteger =
      zio.aws.location.model.primitives
        .CalculateRouteMatrixSummaryErrorCountInteger(impl.errorCount())
    override val distanceUnit: zio.aws.location.model.DistanceUnit =
      zio.aws.location.model.DistanceUnit.wrap(impl.distanceUnit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
  ): zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly = new Wrapper(
    impl
  )
}
