package zio.aws.location.model
import zio.aws.location.model.primitives.{ApiKey, Timestamp, ResourceName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CalculateRouteRequest(
    calculatorName: ResourceName,
    departurePosition: Iterable[Double],
    destinationPosition: Iterable[Double],
    waypointPositions: Optional[Iterable[Iterable[Double]]] = Optional.Absent,
    travelMode: Optional[zio.aws.location.model.TravelMode] = Optional.Absent,
    departureTime: Optional[Timestamp] = Optional.Absent,
    departNow: Optional[Boolean] = Optional.Absent,
    distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      Optional.Absent,
    includeLegGeometry: Optional[Boolean] = Optional.Absent,
    carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions
    ] = Optional.Absent,
    truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions
    ] = Optional.Absent,
    arrivalTime: Optional[Timestamp] = Optional.Absent,
    optimizeFor: Optional[zio.aws.location.model.OptimizationMode] =
      Optional.Absent,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteRequest = {
    import CalculateRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .departurePosition(departurePosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .destinationPosition(destinationPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        waypointPositions.map(value =>
          value.map { item =>
            item.map { item =>
              item: java.lang.Double
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.waypointPositions)
      .optionallyWith(travelMode.map(value => value.unwrap))(_.travelMode)
      .optionallyWith(
        departureTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.departureTime)
      .optionallyWith(departNow.map(value => value: java.lang.Boolean))(
        _.departNow
      )
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .optionallyWith(
        includeLegGeometry.map(value => value: java.lang.Boolean)
      )(_.includeLegGeometry)
      .optionallyWith(carModeOptions.map(value => value.buildAwsValue()))(
        _.carModeOptions
      )
      .optionallyWith(truckModeOptions.map(value => value.buildAwsValue()))(
        _.truckModeOptions
      )
      .optionallyWith(
        arrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.arrivalTime)
      .optionallyWith(optimizeFor.map(value => value.unwrap))(_.optimizeFor)
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteRequest.ReadOnly =
    zio.aws.location.model.CalculateRouteRequest.wrap(buildAwsValue())
}
object CalculateRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteRequest =
      zio.aws.location.model.CalculateRouteRequest(
        calculatorName,
        departurePosition,
        destinationPosition,
        waypointPositions.map(value => value),
        travelMode.map(value => value),
        departureTime.map(value => value),
        departNow.map(value => value),
        distanceUnit.map(value => value),
        includeLegGeometry.map(value => value),
        carModeOptions.map(value => value.asEditable),
        truckModeOptions.map(value => value.asEditable),
        arrivalTime.map(value => value),
        optimizeFor.map(value => value),
        key.map(value => value)
      )
    def calculatorName: ResourceName
    def departurePosition: List[Double]
    def destinationPosition: List[Double]
    def waypointPositions: Optional[List[List[Double]]]
    def travelMode: Optional[zio.aws.location.model.TravelMode]
    def departureTime: Optional[Timestamp]
    def departNow: Optional[Boolean]
    def distanceUnit: Optional[zio.aws.location.model.DistanceUnit]
    def includeLegGeometry: Optional[Boolean]
    def carModeOptions
        : Optional[zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly]
    def truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ]
    def arrivalTime: Optional[Timestamp]
    def optimizeFor: Optional[zio.aws.location.model.OptimizationMode]
    def key: Optional[ApiKey]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getDeparturePosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(departurePosition)
    def getDestinationPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(destinationPosition)
    def getWaypointPositions: ZIO[Any, AwsError, List[List[Double]]] =
      AwsError.unwrapOptionField("waypointPositions", waypointPositions)
    def getTravelMode: ZIO[Any, AwsError, zio.aws.location.model.TravelMode] =
      AwsError.unwrapOptionField("travelMode", travelMode)
    def getDepartureTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("departureTime", departureTime)
    def getDepartNow: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("departNow", departNow)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.location.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
    def getIncludeLegGeometry: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeLegGeometry", includeLegGeometry)
    def getCarModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("carModeOptions", carModeOptions)
    def getTruckModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("truckModeOptions", truckModeOptions)
    def getArrivalTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("arrivalTime", arrivalTime)
    def getOptimizeFor
        : ZIO[Any, AwsError, zio.aws.location.model.OptimizationMode] =
      AwsError.unwrapOptionField("optimizeFor", optimizeFor)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteRequest
  ) extends zio.aws.location.model.CalculateRouteRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val departurePosition: List[Double] = impl
      .departurePosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val destinationPosition: List[Double] = impl
      .destinationPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val waypointPositions: Optional[List[List[Double]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.waypointPositions())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item: Double
            }.toList
          }.toList
        )
    override val travelMode: Optional[zio.aws.location.model.TravelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.travelMode())
        .map(value => zio.aws.location.model.TravelMode.wrap(value))
    override val departureTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.departureTime())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val departNow: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.departNow())
      .map(value => value: Boolean)
    override val distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distanceUnit())
        .map(value => zio.aws.location.model.DistanceUnit.wrap(value))
    override val includeLegGeometry: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeLegGeometry())
      .map(value => value: Boolean)
    override val carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.carModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteCarModeOptions.wrap(value)
      )
    override val truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.truckModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteTruckModeOptions.wrap(value)
      )
    override val arrivalTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.arrivalTime())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val optimizeFor
        : Optional[zio.aws.location.model.OptimizationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizeFor())
        .map(value => zio.aws.location.model.OptimizationMode.wrap(value))
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteRequest
  ): zio.aws.location.model.CalculateRouteRequest.ReadOnly = new Wrapper(impl)
}
