package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  CalculateRouteSummaryDurationSecondsDouble,
  CalculateRouteSummaryDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class CalculateRouteSummary(
    routeBBox: Iterable[Double],
    dataSource: String,
    distance: CalculateRouteSummaryDistanceDouble,
    durationSeconds: CalculateRouteSummaryDurationSecondsDouble,
    distanceUnit: zio.aws.location.model.DistanceUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteSummary = {
    import CalculateRouteSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteSummary
      .builder()
      .routeBBox(routeBBox.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .dataSource(dataSource: java.lang.String)
      .distance(
        CalculateRouteSummaryDistanceDouble.unwrap(distance): java.lang.Double
      )
      .durationSeconds(
        CalculateRouteSummaryDurationSecondsDouble.unwrap(
          durationSeconds
        ): java.lang.Double
      )
      .distanceUnit(distanceUnit.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteSummary.ReadOnly =
    zio.aws.location.model.CalculateRouteSummary.wrap(buildAwsValue())
}
object CalculateRouteSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteSummary =
      zio.aws.location.model.CalculateRouteSummary(
        routeBBox,
        dataSource,
        distance,
        durationSeconds,
        distanceUnit
      )
    def routeBBox: List[Double]
    def dataSource: String
    def distance: CalculateRouteSummaryDistanceDouble
    def durationSeconds: CalculateRouteSummaryDurationSecondsDouble
    def distanceUnit: zio.aws.location.model.DistanceUnit
    def getRouteBBox: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(routeBBox)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDistance: ZIO[Any, Nothing, CalculateRouteSummaryDistanceDouble] =
      ZIO.succeed(distance)
    def getDurationSeconds
        : ZIO[Any, Nothing, CalculateRouteSummaryDurationSecondsDouble] =
      ZIO.succeed(durationSeconds)
    def getDistanceUnit
        : ZIO[Any, Nothing, zio.aws.location.model.DistanceUnit] =
      ZIO.succeed(distanceUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteSummary
  ) extends zio.aws.location.model.CalculateRouteSummary.ReadOnly {
    override val routeBBox: List[Double] = impl
      .routeBBox()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val dataSource: String = impl.dataSource(): String
    override val distance: CalculateRouteSummaryDistanceDouble =
      zio.aws.location.model.primitives
        .CalculateRouteSummaryDistanceDouble(impl.distance())
    override val durationSeconds: CalculateRouteSummaryDurationSecondsDouble =
      zio.aws.location.model.primitives
        .CalculateRouteSummaryDurationSecondsDouble(impl.durationSeconds())
    override val distanceUnit: zio.aws.location.model.DistanceUnit =
      zio.aws.location.model.DistanceUnit.wrap(impl.distanceUnit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteSummary
  ): zio.aws.location.model.CalculateRouteSummary.ReadOnly = new Wrapper(impl)
}
